﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Office = Microsoft.Office.Core;
using Excel = Microsoft.Office.Interop.Excel;

namespace SkoroszytWinForms
{
    partial class ActionsPaneControl1 : UserControl
    {
        CurrencyManager cm;

        public ActionsPaneControl1()
        {
            InitializeComponent();
            
            this.textBox1.DataBindings.Add("Text", 
                Globals.ThisWorkbook.dataSet.Employees, "FirstName");
            this.textBox2.DataBindings.Add("Text", 
                Globals.ThisWorkbook.dataSet.Employees, "LastName");                        
            this.pictureBox1.DataBindings.Add("Image", 
                Globals.ThisWorkbook.dataSet.Employees, "Photo", true);

            cm = (CurrencyManager)this.BindingContext[Globals.ThisWorkbook.dataSet.Employees];    
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (!(cm.Position == 0))
                cm.Position -= 1;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (!(cm.Position == cm.Count - 1))
                cm.Position += 1;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            // Aktywacja wybranego arkusza
            Globals.Arkusz2.Activate();

            // Pobranie iformacji o pracowniku
            System.Data.DataRowView pracownik = (System.Data.DataRowView)cm.Current;
            
            // Umieszczenie danych w arkuszu
            Globals.Arkusz2.Range["A1"].Value2 = "Imię";
            Globals.Arkusz2.Range["B1"].Value2 = pracownik["FirstName"];
            Globals.Arkusz2.Range["A2"].Value2 = "Nazwisko";
            Globals.Arkusz2.Range["B2"].Value2 = pracownik["LastName"];
            Globals.Arkusz2.Range["A3"].Value2 = "Tytuł grzecznościowy";
            Globals.Arkusz2.Range["B3"].Value2 = pracownik["TitleOfCourtesy"];
            Globals.Arkusz2.Range["A4"].Value2 = "Stanowisko";
            Globals.Arkusz2.Range["B4"].Value2 = pracownik["Title"];
            Globals.Arkusz2.Range["A5"].Value2 = "Adres";
            Globals.Arkusz2.Range["B5"].Value2 = pracownik["Address"];
            Globals.Arkusz2.Range["A6"].Value2 = "Kod pocztowy";
            Globals.Arkusz2.Range["B6"].Value2 = pracownik["PostalCode"];
            Globals.Arkusz2.Range["A7"].Value2 = "Miasto";
            Globals.Arkusz2.Range["B7"].Value2 = pracownik["City"];
            Globals.Arkusz2.Range["A8"].Value2 = "Data urodzenia";
            Globals.Arkusz2.Range["B8"].Value2 = pracownik["BirthDate"];
            Globals.Arkusz2.Range["A9"].Value2 = "Data zatrudnienia";
            Globals.Arkusz2.Range["B9"].Value2 = pracownik["HireDate"].ToString();
            
            // Ustawienie formatowania dat
            Globals.Arkusz2.Range["B8", "B9"].NumberFormat = "DD.MM.YYYY";
            
            // Wykorzystanie formuły w celu obliczenia wieku pracownika                        
            Globals.Arkusz2.Range["A10"].Value2 = "Wiek";
            Globals.Arkusz2.Range["B10"].Formula = "=YEAR(TODAY()) - YEAR(B8)";
            Globals.Arkusz2.Range["B10"].NumberFormat = "0";            
            
            Globals.Arkusz2.Range["A11"].Value2 = "Uwagi";
            Globals.Arkusz2.Range["B11"].Value2 = pracownik["Notes"];

            // Formatowanie komórek
            //
            // Wytłuszczenie czcionki
            Globals.Arkusz2.Range["A1", "A11"].Font.Bold = true;
            
            // Wyrównanie zawartości komórek. W poziomie do lewej i wyjustowanie w pionie 
            Globals.Arkusz2.Range["A1", "B11"].HorizontalAlignment = 
                Excel.XlHAlign.xlHAlignLeft;
            Globals.Arkusz2.Range["A10", "B11"].VerticalAlignment = 
                Excel.XlVAlign.xlVAlignJustify;

            // Ustalenie szerokości kolumn
            Globals.Arkusz2.Range["A1", "A11"].ColumnWidth = 25;
            Globals.Arkusz2.Range["B1", "B11"].ColumnWidth = 50;

            // Obramowanie komórek
            Globals.Arkusz2.Range["A1", "B11"].BorderAround(
                Excel.XlLineStyle.xlContinuous, 
                Excel.XlBorderWeight.xlThick, 
                Excel.XlColorIndex.xlColorIndexAutomatic);

            // Zawijanie tekstu
            Globals.Arkusz2.Range["A1", "B11"].WrapText = true;

            // Autodopasowanie wiersza do jego zawartości
            Globals.Arkusz2.Rows[11].AutoFit();                        
        }
    }
}
